<?php
/* --------------------------------------------------------------
   ot_payment.php 2014-07-15 gm
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2014 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------

$Id: ot_payment.php,v 1.2.3 (3.0.4) 2005/10/27 13:55:50 Anotherone Exp $

  Andr� Estel / Estelco http://www.estelco.de

  Copyright (C) 2005 Estelco

  based on:
  Andreas Zimmermann / IT eSolutions http://www.it-esolutions.de

  Copyright (C) 2004 IT eSolutions
  -----------------------------------------------------------------------------------------

  (c) 2003 XT-Commerce - community made shopping http://www.xt-commerce.com 

  Released under the GNU General Public License

  ---------------------------------------------------------------------------------------*/

  class ot_payment_ORIGIN {
    var $title, $output;

    public function __construct() {
      $this->code = 'ot_payment';
      $this->title = defined('MODULE_ORDER_TOTAL_PAYMENT_TITLE') ? MODULE_ORDER_TOTAL_PAYMENT_TITLE : '';
      $this->description = defined('MODULE_ORDER_TOTAL_PAYMENT_DESCRIPTION') ? MODULE_ORDER_TOTAL_PAYMENT_DESCRIPTION : '';
      $this->enabled = defined('MODULE_ORDER_TOTAL_PAYMENT_STATUS') && MODULE_ORDER_TOTAL_PAYMENT_STATUS === 'true';
      $this->sort_order = defined('MODULE_ORDER_TOTAL_PAYMENT_SORT_ORDER') ? MODULE_ORDER_TOTAL_PAYMENT_SORT_ORDER : '0';
      $this->include_shipping = defined('MODULE_ORDER_TOTAL_PAYMENT_INC_SHIPPING') ? MODULE_ORDER_TOTAL_PAYMENT_INC_SHIPPING : 'false';
      $this->include_tax = defined('MODULE_ORDER_TOTAL_PAYMENT_INC_TAX') ? MODULE_ORDER_TOTAL_PAYMENT_INC_TAX : 'true';
      $this->percentage = defined('MODULE_ORDER_TOTAL_PAYMENT_PERCENTAGE') ? MODULE_ORDER_TOTAL_PAYMENT_PERCENTAGE : '100:4';
      $this->percentage2 = defined('MODULE_ORDER_TOTAL_PAYMENT_PERCENTAGE2') ? MODULE_ORDER_TOTAL_PAYMENT_PERCENTAGE2 : '100:2'; //neu
      $this->calculate_tax = defined('MODULE_ORDER_TOTAL_PAYMENT_CALC_TAX') ? MODULE_ORDER_TOTAL_PAYMENT_CALC_TAX : 'true';
      $this->amount1_desc = defined('MODULE_ORDER_TOTAL_PAYMENT_AMOUNT1') ? MODULE_ORDER_TOTAL_PAYMENT_AMOUNT1 : '';
      $this->amount2_desc = defined('MODULE_ORDER_TOTAL_PAYMENT_AMOUNT2') ? MODULE_ORDER_TOTAL_PAYMENT_AMOUNT2 : '';
      $this->output = array();
    }

    function process() {
      global $order, $currencies, $xtPrice;

      $allowed_zones = explode(',', MODULE_ORDER_TOTAL_PAYMENT_ALLOWED);

      if ($this->enabled && (in_array($_SESSION['delivery_zone'], $allowed_zones) == true || MODULE_ORDER_TOTAL_PAYMENT_ALLOWED == '')) {
        $discount = $this->calculate_credit($this->xtc_order_total());
        if ($discount['sum']!=0) {
           $this->deduction = $discount['sum'];
           if ($discount['amount1']!=0) {
               $this->output[] = array('title' => abs($discount['pro1']) . "% " . $this->amount1_desc . ':',
                                       'text' => $discount['amount1']>0 ? $xtPrice->xtcFormat($discount['sum'], true) : $xtPrice->xtcFormat($discount['sum'], true),
                                       'value' => $discount['sum']);
           } elseif ($discount['amount2']!=0) {
               $this->output[] = array('title' => abs($discount['pro2']) . "% " . $this->amount2_desc . ':',
                                       'text' => $discount['amount2']>0 ? $xtPrice->xtcFormat($discount['sum'], true) : $xtPrice->xtcFormat($discount['sum'], true),
                                       'value' => $discount['sum']);
           }
           // BOF GM_MOD:
           $order->info['subtotal'] = $order->info['subtotal'] + $discount['sum'];
           $order->info['total'] = $order->info['total'] + $discount['sum'];
        }
      }
    }


  function calculate_credit($amount) {
    global $order, $customer_id, $payment;
    $od_amount=0;
    $od_amount2=0; //neu
    $discount = array();
    $do = false;

    $discount_table = (preg_split('/[:,]/' , $this->percentage));

    for ($i=0; $i<sizeof($discount_table); $i+=2) {
      if ($amount >= $discount_table[$i]) {
        $od_pc = $discount_table[$i+1];
        $minimum = $discount_table[$i];
      } else {
        break;
      }
    }

    $discount_table = (preg_split('/[:,]/' , $this->percentage2));

    for ($i=0; $i<sizeof($discount_table); $i+=2) {
      if ($amount >= $discount_table[$i]) {
        $od_pc2 = $discount_table[$i+1];
        $minimum2 = $discount_table[$i];
      } else {
        break;
      }
    }

    if ($amount >= $minimum) {
    $table = explode(',' , MODULE_ORDER_TOTAL_PAYMENT_TYPE);
    for ($i = 0; $i < count($table); $i++) {
          if ($_SESSION['payment'] == $table[$i]) $do = true;
        }
    if ($do) {
    // Calculate tax reduction if necessary
    if($this->calculate_tax == 'true') {
    // Calculate main tax reduction
      // BOF GM_MOD:
      $tod_amount = round($order->info['tax']*100)/100*$od_pc/100;
      $order->info['tax'] = $order->info['tax'] - $tod_amount;
      // Calculate tax group deductions
      reset($order->info['tax_groups']);
      foreach($order->info['tax_groups'] as $key => $value) {
        // BOF GM_MOD:
      	$god_amount = round($value*100)/100*$od_pc/100;
        $order->info['tax_groups'][$key] = $order->info['tax_groups'][$key] - $god_amount;
      }
    }
    // BOF GM_MOD:
    $od_amount = round($amount*100)/100*$od_pc/100;
    //    $od_amount = $od_amount + $tod_amount; //auskommentieren, da sonst die Steuer 2x rabattiert wird
	    $discount['amount1'] = $od_amount;
	    $discount['pro1'] = $od_pc;
    }
    }

//Zweiten Rabatt berechnen...

    $amount2 = $amount - $od_amount; //diese zeile anpassen um Prozente gleichzeitig ("$amount2 = $amount;") oder nacheinander ("$amount2 = $amount - $od_amount;") zu berechnen
    $do = false;
    if ($amount2 >= $minimum2) {
    $table = explode(',' , MODULE_ORDER_TOTAL_PAYMENT_TYPE2);
    for ($i = 0; $i < count($table); $i++) {
          if ($_SESSION['payment'] == $table[$i]) $do = true;
        }
    if ($do) {
    // Calculate tax reduction if necessary
    if($this->calculate_tax == 'true') {
    // Calculate main tax reduction
      // BOF GM_MOD:
      $tod_amount2 = round($order->info['tax']*100)/100*$od_pc2/100;
      $order->info['tax'] = $order->info['tax'] - $tod_amount2; //diese Zeile auskommentieren, wenn beide Prozente zusammen berechnet werden sollen
      // Calculate tax group deductions
      reset($order->info['tax_groups']);
      foreach($order->info['tax_groups'] as $key => $value) {
        // BOF GM_MOD:
      	$god_amount2 = round($value*100)/100*$od_pc2/100;
        $order->info['tax_groups'][$key] = $order->info['tax_groups'][$key] - $god_amount2;
      }
    }
    // BOF GM_MOD:
    $od_amount2 = round($amount2*100)/100*$od_pc2/100;
    //    $od_amount2 = $od_amount2 + $tod_amount2; //auskommentieren, da sonst die Steuer 2x rabattiert wird
	    $discount['amount2'] = $od_amount2;
	    $discount['pro2'] = $od_pc2;
    }
    }
    //  $order->info['tax'] = $order->info['tax'] - $tod_amount - $tod_amount2; //diese Zeile auskommentieren, wenn die Prozente nacheinander berechnet werden sollen
    $discount['sum'] = -($od_amount + $od_amount2);
   
    return $discount;
  }


  function xtc_order_total() {
    global  $order, $cart;
    $order_total = $order->info['total'];
// Check if gift voucher is in cart and adjust total
    $products = $_SESSION['cart']->get_products();
    for ($i=0; $i<sizeof($products); $i++) {
      $t_prid = xtc_get_prid($products[$i]['id']);
      $gv_query = xtc_db_query("select products_price, products_tax_class_id, products_model from " . TABLE_PRODUCTS . " where products_id = '" . $t_prid . "'");
		// bof gm
		$gv_result = xtc_db_fetch_array($gv_query);
		if(!is_object($cart)) {
			$cart = $_SESSION['cart'];
		}
		// eof gm	
      if (preg_match('/^GIFT/', addslashes($gv_result['products_model']))) {
        $qty = $cart->get_quantity($t_prid);
        $products_tax = xtc_get_tax_rate($gv_result['products_tax_class_id']);
        if ($this->include_tax =='false') {
           $gv_amount = $gv_result['products_price'] * $qty;
        } else {
          $gv_amount = ($gv_result['products_price'] + xtc_calculate_tax($gv_result['products_price'],$products_tax)) * $qty;
        }
        $order_total=$order_total - $gv_amount;
      }
    }
    if ($this->include_shipping == 'false') $order_total=$order_total-$order->info['shipping_cost'];
    if ($this->include_tax == 'false') if($_SESSION['customers_status']['customers_status_add_tax_ot']=='0') $order_total=$order_total-$order->info['tax'];
    return $order_total;
  }


    function check() {
      if (!isset($this->check)) {
        $check_query = xtc_db_query("select `value` from `gx_configurations` where `key` = 'configuration/MODULE_ORDER_TOTAL_PAYMENT_STATUS'");
        $this->check = xtc_db_num_rows($check_query);
      }

      return $this->check;
    }

    function keys() {
      return array('configuration/MODULE_ORDER_TOTAL_PAYMENT_STATUS', 'configuration/MODULE_ORDER_TOTAL_PAYMENT_SORT_ORDER', 'configuration/MODULE_ORDER_TOTAL_PAYMENT_PERCENTAGE', 'configuration/MODULE_ORDER_TOTAL_PAYMENT_PERCENTAGE2', 'configuration/MODULE_ORDER_TOTAL_PAYMENT_TYPE', 'configuration/MODULE_ORDER_TOTAL_PAYMENT_TYPE2', 'configuration/MODULE_ORDER_TOTAL_PAYMENT_INC_SHIPPING', 'configuration/MODULE_ORDER_TOTAL_PAYMENT_INC_TAX', 'configuration/MODULE_ORDER_TOTAL_PAYMENT_CALC_TAX', 'configuration/MODULE_ORDER_TOTAL_PAYMENT_ALLOWED', 'configuration/MODULE_ORDER_TOTAL_PAYMENT_TAX_CLASS'); //, 'MODULE_ORDER_TOTAL_PAYMENT_HOWTO_CALC', 'MODULE_ORDER_TOTAL_PAYMENT_MINIMUM', 'MODULE_ORDER_TOTAL_PAYMENT_MINIMUM2'
    }

    function install() {
      xtc_db_query("insert into `gx_configurations` (`key`, `value`, `legacy_group_id`, `sort_order`, `type`) values ('configuration/MODULE_ORDER_TOTAL_PAYMENT_STATUS', 'true', '6', '1','switcher')");
      xtc_db_query("insert into `gx_configurations` (`key`, `value`, `legacy_group_id`, `sort_order`) values ('configuration/MODULE_ORDER_TOTAL_PAYMENT_SORT_ORDER', '49', '6', '2')");
      xtc_db_query("insert into `gx_configurations` (`key`, `value`, `legacy_group_id`, `sort_order`, `type`) values ('configuration/MODULE_ORDER_TOTAL_PAYMENT_INC_SHIPPING', 'false', '6', '5', 'switcher')");
      xtc_db_query("insert into `gx_configurations` (`key`, `value`, `legacy_group_id`, `sort_order`, `type`) values ('configuration/MODULE_ORDER_TOTAL_PAYMENT_INC_TAX', 'true', '6', '6','switcher')");
      xtc_db_query("insert into `gx_configurations` (`key`, `value`, `legacy_group_id`, `sort_order`) values ('configuration/MODULE_ORDER_TOTAL_PAYMENT_PERCENTAGE', '100:4', '6', '4')");
      xtc_db_query("insert into `gx_configurations` (`key`, `value`, `legacy_group_id`, `sort_order`) values ('configuration/MODULE_ORDER_TOTAL_PAYMENT_PERCENTAGE2', '100:2', '6', '4')");
      xtc_db_query("insert into `gx_configurations` (`key`, `value`, `legacy_group_id`, `sort_order`, `type`) values ('configuration/MODULE_ORDER_TOTAL_PAYMENT_CALC_TAX', 'true', '6', '5','switcher')");
      xtc_db_query("insert into `gx_configurations` (`key`, `value`, `legacy_group_id`, `sort_order`) values ('configuration/MODULE_ORDER_TOTAL_PAYMENT_TYPE', 'moneyorder', '6', '3')");
      xtc_db_query("insert into `gx_configurations` (`key`, `value`, `legacy_group_id`, `sort_order`) values ('configuration/MODULE_ORDER_TOTAL_PAYMENT_TYPE2', 'cod', '6', '3')");
      xtc_db_query("insert into `gx_configurations` (`key`, `value`, `legacy_group_id`, `sort_order`) values ('configuration/MODULE_ORDER_TOTAL_PAYMENT_ALLOWED', '',   '6', '2')");
      xtc_db_query("insert into `gx_configurations` (`key`, `value`, `legacy_group_id`, `sort_order`, `type`) values ('configuration/MODULE_ORDER_TOTAL_PAYMENT_TAX_CLASS', '0','6', '7', 'tax-class')");
    }

    function remove() {
      $keys = '';
      $keys_array = $this->keys();
      for ($i=0; $i<sizeof($keys_array); $i++) {
        $keys .= "'" . $keys_array[$i] . "',";
      }
      $keys = substr($keys, 0, -1);

      xtc_db_query("delete from `gx_configurations` where `key` in (" . $keys . ")");
    }

  }

MainFactory::load_origin_class('ot_payment');